/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import compasses.expandedstorage.forge.ForgeClient;
import compasses.expandedstorage.forge.block.misc.ChestItemAccess;
import compasses.expandedstorage.forge.block.misc.GenericItemAccess;
import compasses.expandedstorage.forge.item.ChestBlockItem;
import compasses.expandedstorage.forge.item.ChestMinecartItem;
import compasses.expandedstorage.forge.item.MiniStorageBlockItem;
import compasses.expandedstorage.forge.misc.ForgeCommonHelper;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import compasses.expandedstorage.impl.block.misc.BasicLockable;
import compasses.expandedstorage.impl.block.misc.CopperBlockHelper;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.ConversionRecipeReloadListener;
import compasses.expandedstorage.impl.registration.Content;
import compasses.expandedstorage.impl.registration.NamedValue;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="expandedstorage")
public final class ForgeMain {
    public ForgeMain() {
        CommonMain.constructContent(new ForgeCommonHelper(), GenericItemAccess::new, BasicLockable::new, FMLLoader.getDist().isClient(), this::registerContent, false, ChestBlockItem::new, ChestItemAccess::new, ChestMinecartItem::new, (TagKey<Block>)TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.BLOCKS, (ResourceLocation)new ResourceLocation("forge", "barrels/wooden")), MiniStorageBlockItem::new);
        MinecraftForge.EVENT_BUS.addListener(event -> event.addListener((PreparableReloadListener)new ConversionRecipeReloadListener()));
        MinecraftForge.EVENT_BUS.addListener(event -> CommonMain.platformHelper().sendConversionRecipesToClient(event.getPlayer(), ConversionRecipeManager.INSTANCE.getBlockRecipes(), ConversionRecipeManager.INSTANCE.getEntityRecipes()));
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            Object patt4086$temp = event.getObject();
            if (patt4086$temp instanceof OpenableBlockEntity) {
                final OpenableBlockEntity entity = (OpenableBlockEntity)patt4086$temp;
                event.addCapability(Utils.id("item_access"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                        if (capability == ForgeCapabilities.ITEM_HANDLER) {
                            return LazyOptional.of(() -> CommonMain.getItemAccess(entity.m_58904_(), entity.m_58899_(), entity.m_58900_(), entity).map(ItemAccess::get).orElseThrow());
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = CommonMain.interactWithEntity(event.getLevel(), event.getEntity(), event.getHand(), event.getTarget());
            if (result != InteractionResult.PASS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> helper.register(Utils.HANDLER_TYPE_ID, CommonMain.platformHelper().getScreenHandlerType())));
    }

    private void registerContent(Content content) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> {
            event.register(ForgeRegistries.Keys.STAT_TYPES, helper -> content.getStats().forEach(it -> Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)it, (Object)it)));
            event.register(ForgeRegistries.Keys.BLOCKS, helper -> CommonMain.iterateNamedList(content.getBlocks(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.ITEMS, helper -> CommonMain.iterateNamedList(content.getItems(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> {
                ForgeMain.registerBlockEntity(helper, content.getChestBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getOldChestBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getBarrelBlockEntityType());
                ForgeMain.registerBlockEntity(helper, content.getMiniChestBlockEntityType());
            });
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> CommonMain.iterateNamedList(content.getEntityTypes(), (arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(Registries.f_279569_, helper -> helper.register(Utils.id("tab"), (Object)CreativeModeTab.builder().m_257737_(() -> ((Item)ForgeRegistries.ITEMS.getValue(Utils.id("netherite_chest"))).m_7968_()).m_257501_((itemDisplayParameters, output) -> CommonMain.generateDisplayItems(itemDisplayParameters, stack -> output.m_246267_(stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS))).m_257941_((Component)Component.m_237115_((String)"itemGroup.expandedstorage.tab")).m_257652_()));
        });
        Supplier originalWaxablesMap = HoneycombItem.f_150863_;
        HoneycombItem.f_150863_ = Suppliers.memoize(() -> ForgeMain.lambda$registerContent$17((Supplier)originalWaxablesMap));
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ForgeClient.initialize(modBus, content);
        }
    }

    private static <T extends BlockEntity> void registerBlockEntity(RegisterEvent.RegisterHelper<BlockEntityType<?>> helper, NamedValue<BlockEntityType<T>> blockEntityType) {
        helper.register(blockEntityType.getName(), blockEntityType.getValue());
    }

    private static /* synthetic */ BiMap lambda$registerContent$17(Supplier originalWaxablesMap) {
        return ImmutableBiMap.builder().putAll((Map)originalWaxablesMap.get()).putAll((Map)CopperBlockHelper.dewaxing().inverse()).build();
    }
}

